/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.file.FileBufferPool;
import net.java.truevfs.driver.file.FileInputSocket;
import net.java.truevfs.driver.file.FileOutputSocket;
import net.java.truevfs.kernel.spec.FsAbstractNode;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsNodeName;

@Immutable
class FileNode
extends FsAbstractNode
implements IoBuffer {
    private static final Path CURRENT_DIRECTORY = Paths.get(".", new String[0]);
    private final Path path;
    private final String name;
    @CheckForNull
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    volatile FileBufferPool pool;

    FileNode(Path path) {
        assert (null != path);
        this.path = path;
        this.name = path.toString();
    }

    FileNode(Path path, FsNodeName name) {
        assert (null != path);
        this.path = path.resolve(name.getPath());
        this.name = name.toString();
    }

    private BasicFileAttributes readBasicFileAttributes() throws IOException {
        return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
    }

    final FileNode createIoBuffer() throws IOException {
        FileBufferPool pool = this.pool;
        if (null == pool) {
            this.pool = pool = new FileBufferPool(this.getParent(), this.getFileName());
        }
        return pool.allocate();
    }

    private Path getParent() {
        Path path = this.path.getParent();
        return null != path ? path : CURRENT_DIRECTORY;
    }

    private String getFileName() {
        Path path = this.path.getFileName();
        return null != path ? path.toString() : "";
    }

    public void release() throws IOException {
    }

    final Path getPath() {
        return this.path;
    }

    public final String getName() {
        return this.name.replace(File.separatorChar, '/');
    }

    public final BitField<Entry.Type> getTypes() {
        try {
            BasicFileAttributes attr = this.readBasicFileAttributes();
            if (attr.isRegularFile()) {
                return FILE_TYPE;
            }
            if (attr.isDirectory()) {
                return DIRECTORY_TYPE;
            }
            if (attr.isSymbolicLink()) {
                return SYMLINK_TYPE;
            }
            if (attr.isOther()) {
                return SPECIAL_TYPE;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return NO_TYPES;
    }

    public final boolean isType(Entry.Type type) {
        try {
            switch (type) {
                case FILE: {
                    return this.readBasicFileAttributes().isRegularFile();
                }
                case DIRECTORY: {
                    return this.readBasicFileAttributes().isDirectory();
                }
                case SYMLINK: {
                    return this.readBasicFileAttributes().isSymbolicLink();
                }
                case SPECIAL: {
                    return this.readBasicFileAttributes().isOther();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public final long getSize(Entry.Size type) {
        try {
            return this.readBasicFileAttributes().size();
        }
        catch (IOException ignore) {
            return -1L;
        }
    }

    public final long getTime(Entry.Access type) {
        try {
            BasicFileAttributes attr = this.readBasicFileAttributes();
            switch (type) {
                case CREATE: {
                    return attr.creationTime().toMillis();
                }
                case READ: {
                    return attr.lastAccessTime().toMillis();
                }
                case WRITE: {
                    return attr.lastModifiedTime().toMillis();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        if (!(entity instanceof Entry.PosixEntity)) {
            return null;
        }
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(this.path, new LinkOption[0]);
            switch ((Entry.PosixEntity)entity) {
                case USER: {
                    switch (type) {
                        case READ: {
                            return permissions.contains((Object)PosixFilePermission.OWNER_READ);
                        }
                        case WRITE: {
                            return permissions.contains((Object)PosixFilePermission.OWNER_WRITE);
                        }
                        case EXECUTE: {
                            return permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE);
                        }
                    }
                    break;
                }
                case GROUP: {
                    switch (type) {
                        case READ: {
                            return permissions.contains((Object)PosixFilePermission.GROUP_READ);
                        }
                        case WRITE: {
                            return permissions.contains((Object)PosixFilePermission.GROUP_WRITE);
                        }
                        case EXECUTE: {
                            return permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
                        }
                    }
                    break;
                }
                case OTHER: {
                    switch (type) {
                        case READ: {
                            return permissions.contains((Object)PosixFilePermission.OTHERS_READ);
                        }
                        case WRITE: {
                            return permissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
                        }
                        case EXECUTE: {
                            return permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
                        }
                    }
                }
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Set<String> getMembers() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Path member : stream) {
                result.add(member.getFileName().toString());
            }
            LinkedHashSet<String> linkedHashSet = result;
            return linkedHashSet;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public final InputSocket<FileNode> input() {
        return this.input((BitField<FsAccessOption>)FsAccessOptions.NONE);
    }

    final InputSocket<FileNode> input(BitField<FsAccessOption> options) {
        return new FileInputSocket(options, this);
    }

    public final OutputSocket<FileNode> output() {
        return this.output((BitField<FsAccessOption>)FsAccessOptions.NONE, null);
    }

    final OutputSocket<FileNode> output(BitField<FsAccessOption> options, @CheckForNull Entry template) {
        return new FileOutputSocket(options, this, template);
    }
}

